﻿/*
// Zinc method
var xmlString = mdm.FileSystem.loadFile( fileName );
if( xmlString != "false" )
{
	XML.prototype.ignoreWhite = true;
	var newXml = new XML( xmlString );
	_global.DATA.map = new Object();		// clear current map data
	readXml( newXml, _global.DATA );
	// reset the map display
	_parent.gotoAndPlay("reset");
}
*/



// Display map name
var startAt = fileName.lastIndexOf("\\") + 1;
var file = fileName.substr(startAt);
mdm.Forms.MainForm.title = "Map Editor:  "+file;

// remember last folder used
var endAt = fileName.lastIndexOf("\\") + 1;
var path = fileName.substr(0, endAt);
Dialogs.BrowseFile.defaultDirectory = path;



// Flash method		(probably faster)
XML.prototype.ignoreWhite = true;
var newXml = new XML();
newXml.load( fileName );
newXml.onLoad = function( success )
{
	// check for map tag
	#include "functions/findXmlTag.as"
	map_xml = findXmlTag( "map", newXml );
	if( map_xml == undefined )
	{
		mdm.Dialogs.prompt("No map data found.")
	}// if:  no map data is found withint the XML file
	
	// convert XML to native objects
	if(success  &&  map_xml)
	{
		_global.DATA.map = new Object();		// clear current map data
		readXml( map_xml, _global.DATA.map );
		// optionally convert "compact" collision data  ->  2D collision array
		if(_global.DATA.map.format==2)
		{// if:  using "compact" format
			// convert collision string to 2D-array
			var collisionString = DATA.map.collision;		// copy the data
			var readIndex = 1;
			if( collisionString.length > 1)
			{// if:  collision data exists
				DATA.map.collision = new Array();
				for(var xx=0; xx<DATA.map.width; xx++)
				{
					DATA.map.collision[xx] = new Array();
					for(var yy=0; yy<DATA.map.height; yy++)
					{
						// get data & convert it from:  base-36 string array -> 2D-array of Numbers
						var thisString = collisionString.charAt( readIndex );
						var thisValue = parseInt( thisString, 36 );
						readIndex++;
						// write data
						DATA.map.collision[xx][yy] = thisValue;
					}// for y
				}// for x
			}// if:  collision data exists
			
			// convert layer strings to 2D-arrays
			for (lay=0; lay<DATA.map.layers.length; lay++)
			{
				var readIndex = 1;
				var layerString = DATA.map.layers[lay];
				DATA.map.layers[lay] = new Array();
				for (var xx=0; xx<DATA.map.width; xx++)
				{
					DATA.map.layers[lay][xx] = new Array();
					for (var yy=0; yy<DATA.map.height; yy++)
					{
						// get data & convert it from:  base-36 string array -> 2D-array of Numbers
						var thisString = layerString.substr( readIndex, 2 );
						var thisValue = parseInt( thisString, 36 );
						readIndex+=2;
						DATA.map.layers[lay][xx][yy] = thisValue;
					}// for:  width
				}// for:  height
			}// for:  layers
		}// if:  using "compact" format
		DATA.map.format = 1;		// set editor data to "old" format  (which mirrors a map's internal data)
		// reset the map display
		_parent.gotoAndPlay("reset");
	}// if:  if the file exists
}// onLoad()
